

#define WATER_PROG
#define WAVY_STRENGTH 1.0 //[0.1 0.25 0.5 0.75 1.0 1.25 1.5 1.75 2.0]
#define WAVY_SPEED 0.0025 //[0.001 0.01 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 1.0 1.25 1.5 2.0 3.0 4.0]

flat varying vec4 labvalue;
varying vec3 p3;

varying mat3 tbnMatrix;
varying vec4 color;
varying float iswater;
varying vec4 lmtexcoord;
varying vec3 torch;
varying vec3 viewVector;
varying vec3 normal0;
varying vec3 normal1;

attribute vec4 at_tangent;
attribute vec4 mc_Entity;

#include "/lib/sky_function.glsl"

const vec3 torchColor = vec3(3.000, 1.382, 0.408);

#define diagonal3(m) vec3((m)[0].x, (m)[1].y, m[2].z)
#define projMAD(m, v) (diagonal3(m) * (v) + (m)[3].xyz)

vec3 waterNormal(vec2 coord, vec3 normFragpos)
{
    coord = mod(coord / 64.0, 1.0);
    float strength = 1.0;

    float deltaPos = 0.0012;

    vec2 offsets[4] = vec2[](vec2(deltaPos, 0.0), vec2(-deltaPos, 0.0), vec2(0.0, deltaPos), vec2(0.0, -deltaPos));

    float heights[4];
    for (int i = 0; i < 4; i++)
    {
        heights[i] = texture(gaux4, coord + offsets[i]).x;
    }

    float dx = (heights[1] - heights[0]) * strength;
    float dy = (heights[3] - heights[2]) * strength;
    vec3 full = normalize(vec3(dx, dy, 0.5)) - vec3(0, 0, 1);

    return full;
}

vec3 computeWaveOffset(vec3 position, vec3 cameraPosition, vec4 vertex, vec4 MultiTexCoord, mat4 gbufferModelView,
                       vec3 posxz, vec3 viewVector)
{

    vec3 test = waterNormal(posxz.xz - posxz.y, normalize(viewVector));
    vec3 offsetWorldPos = vertex.xyz + cameraPosition;
    vec3 waveOffset = test;
    vec3 worldPos = offsetWorldPos + waveOffset - cameraPosition;
    return mat3(gbufferModelView) * worldPos + gbufferModelView[3].xyz;
}
vec4 getMaterialProperties(int materialIndex)
{
    // Reflectance, Smoothness, Subsurface amounts, and Porosity
    switch (materialIndex)
    {
    case 8: // water
        return vec4(0.02, 0.9, 0.0, 0.0);
    case 50: // glass
    case 51: // glass
    case 52: // glass
    case 53: // glass
    case 54: // glass
    case 55: // glass
    case 56: // glass
    case 57: // glass
    case 58: // glass
    case 59: // glass
    case 60: // glass
    case 61: // glass
    case 62: // glass
    case 63: // glass
    case 64: // glass
    case 65: // glass
    case 66: // glass
        return vec4(0.04, 0.95, 0.0, 0.0);
    case 67: // honey
        return vec4(0.04, 0.5, 0.5, 0.0);
    case 68: // ice
        return vec4(0.02, 0.9, 0.5, 0.0);
    case 69: // slime
        return vec4(0.03, 0.9, 0.5, 0.0);
    default:
        return vec4(0.0, 0.0, 0.0, 0.0);
        // Default value if index is out of range
    }
}
vec4 toClipSpace_dh(vec3 viewSpacePosition)
{
    return vec4(projMAD(dhProjection, viewSpacePosition), -viewSpacePosition.z);
}

void main()
{
    bool tangentValid = dot(at_tangent.xyz, at_tangent.xyz) > 1e-9; // TODO: Get at_tangent fixed so this isn't needed
    tbnMatrix[0] =
        mat3(gbufferModelViewInverse) * (tangentValid ? normalize(gl_NormalMatrix * at_tangent.xyz) : vec3(0.0));
    tbnMatrix[2] = mat3(gbufferModelViewInverse) * (normalize(gl_NormalMatrix * gl_Normal));
    tbnMatrix[1] = cross(tbnMatrix[0], tbnMatrix[2]) * (at_tangent.w < 0.0 ? -1.0 : 1.0);

    lmtexcoord.xy = (gl_TextureMatrix[0] * gl_MultiTexCoord0).st;

    labvalue = vec4(0);
    int entityCheck = int(mc_Entity.x);

    labvalue = vec4(0.0, 0.0, 0.0, 0.0);
    if (dhMaterialId == 12)
        labvalue = vec4(0.02, 0.9, 0.0, 0.0);

    viewVector = (gl_ModelViewMatrix * gl_Vertex).xyz;
    color = gl_Color;

    normal0 = gl_NormalMatrix * gl_Normal;
    normal1 = gl_Normal;
    p3 = gl_Vertex.xyz;

    lmtexcoord.zw = clamp(pow(gl_MultiTexCoord1.xy, vec2(2.0)) * 1.1, 0, 1);
    iswater = 0.0;
    if (dhMaterialId == 12)
        iswater = 1.0;
    if (dhMaterialId == 0)
        iswater = 0.8;

    float lmx = gl_MultiTexCoord1.x * recip;
    // torch = vec3(3.000, 1.382, 0.408);
    torch = mix(vec3(1.0), vec3(3.000, 1.382, 0.408), 0.25);
    float lightmapX4 = lmx * lmx * lmx * lmx;
    torch *= lightmapX4 + lmx * 0.025;

    // gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;

    vec3 position = mat3(gl_ModelViewMatrix) * gl_Vertex.xyz + gl_ModelViewMatrix[3].xyz;

    gl_Position = taaFunc(toClipSpace_dh(position));
}
